/* JM-Solutions, Erweiterte CSV Schnittstelle für VARIAL World Edition 
Abklärung mit Herr Fridolin Lukic  VARIAL: 

* Dateiname 
** Muss 'Rechnung-Gutschrift' sein ...
** Unterteilung nach Buchungmonat ist ok
** Wir exportieren in unsereren Buchhaltungsordner und können neue Rechnungen einfach an Dateien anhängen
** Varial ließt Dateien ein, kopiert Dateien in Backupordner, leert unser Verzeichnis

* TODO: Varial - Firmennummer von RS-UAS rausbekommen
* TODO: Abweichende Steuersätze über Umschlüsselung Steuercodes
*/

----------------------------------------------------------------------------------------------------------------------------------------
-- Details und vollständige Schnittstellenbeschreibung im Wiki: http://redmine.prodat-sql.de/projects/rs-uas/wiki/VARIAL_-_EDI        -- 
----------------------------------------------------------------------------------------------------------------------------------------
        
 
-- Formatierung von Zahlenwerten / Geldbeträgen in das von Varial geforderte Format
CREATE OR REPLACE FUNCTION x_900_export.VarialFMT(wert NUMERIC, Round2 BOOLEAN DEFAULT FALSE) RETURNS VARCHAR(20) AS $$
     SELECT 
        CASE WHEN Round2 THEN TRIM(to_Char(ROUND(ABS(wert),2), '999999999999990D999')) :: VARCHAR(20)
             ELSE             TRIM(to_Char(ROUND(ABS(wert),3), '999999999999990D999')) :: VARCHAR(20)
        END;
   -- -1234,5 wird 1234,500
   -- -0.0005 wird 0,001
   -- 0,1235  wird 0,123
  $$ LANGUAGE SQL STABLE;
--

-- Bestellnummern bis 40 Zeichen zusammensuchen und als Auftragsnummer an Varial weitergeben ... 
CREATE OR REPLACE FUNCTION x_900_export.VarialAuftgNr(IN beld_id INTEGER) RETURNS VARCHAR(40) AS $$
 DECLARE nr  VARCHAR(40);
         rec RECORD;
         anz INTEGER;
         i   INTEGER;
 BEGIN 
   Nr := ''; i := 0; anz := 0;
   FOR rec IN SELECT DISTINCT ld_auftg FROM belegpos JOIN ldsdok ON belp_ld_id = ld_id WHERE belp_dokument_id = beld_id ORDER BY ld_auftg LOOP
     anz:=anz+1;
     IF LENGTH(nr||rec.ld_auftg)+1 < 36 THEN 
       i:=i+1;
       nr := nr || IfThen(nr <> '', ',','') || rec.ld_auftg;       
     END IF;     
     -- RAISE NOTICE '%: %', anz, rec.ld_auftg;
   END LOOP;
   IF anz > i THEN
     nr := nr || '[+' || anz-i || ']';
   END IF;
   RETURN nr;   
 END $$ LANGUAGE plpgsql STABLE;
--

-- Bestehende Views Droppen  
CREATE OR REPLACE FUNCTION TSystem.views__x_900_export__Varial__drop() RETURNS VOID AS $$
 BEGIN
   
    DROP VIEW IF EXISTS x_900_export.VarialRG;
    DROP VIEW IF EXISTS x_900_export.VarialRGPos;
    DROP VIEW IF EXISTS x_900_export.VarialERG;
    DROP VIEW IF EXISTS x_900_export.VarialERGPos;
    
 END $$ LANGUAGE 'plpgsql' VOLATILE;
--
-- Exportviews für Varial-Buchhaltung neu erstellen
CREATE OR REPLACE FUNCTION TSystem.views__x_900_export__varial__recreate() RETURNS VOID AS $$
 BEGIN
  /*
    
  -- Eingangsrechnungspositionen und Ab- / Zuschläge als Zeilen abgebildet
  CREATE OR REPLACE VIEW x_900_export.VarialERGPos AS
    
    -- Belegpositionen
    SELECT  
      belp_konto                                                 :: VARCHAR(20)             AS pSachkonto    , -- 29	
      IfThen(belp_netto < 0, 'T','F')                            :: VARCHAR(1)              AS pGutschrift   , -- 30	
      x_900_export.VarialFMT(ABS(posNettoBW))                                                    AS pNetto        , -- 31 Pos.Netto, 2 NK-Stellen
      x_900_export.VarialFMT(IfThen(posNettoBW <> posNettoFW, ABS(posNettoFW),NULL))             AS pNettoFW      , -- 32 Pos.Netto, 2 NK-Stellen, Fremdwährung
      x_900_export.VarialFMT(ABS( posBruttoBW - posNettoBW))                                     AS pSteuer       , -- 33 Steuerbetrag, 2 NK-Stellen
      x_900_export.VarialFMT(IfThen(posNettoBW <> posNettoFW, ABS(posBruttoFW-posNettoFW),NULL)) AS pSteuerFW     , -- 34 Steuerbetrag, 2 NK-Stellen, Fremwährung
      steu_buchcode                                              :: VARCHAR(20)             AS pSteuerCode   , -- 35
  	  IfThen(belp_skontofaehig, 'T','F')                         :: VARCHAR(1)              AS pCanSkonto    , -- 36	
      'T'                                                        :: VARCHAR(1)              AS pIstNetto     , -- 37	
      'Pos.' || belp_pos || ', ' || COALESCE(belp_akbez, ak_bez) :: VARCHAR(80)             AS pBuchText     , -- 38 Buchungstext zur Position	
      COALESCE(ks_buchcode, belp_kostenstelle)                   :: VARCHAR(30)             AS pKostenstelle , -- 39        
      COALESCE(an_buchcode, belp_projektnummer,ag_nr)            :: VARCHAR(40)             AS pKostenträger , -- 40 Projekt oder Auftrag als Kostenträger
   	  belp_dokument_id                                                                      AS pDokumentID   , -- Zugehörige Eingangsrechnung
   	  1                                                                                     AS pOrderby        -- Sortieren nach Zeilentyp 
    FROM eingrech_pos AS belegpos
      JOIN eingrech      ON belp_dokument_id   = beld_id
      JOIN steutxt       ON belp_steucode      = steu_z
      JOIN art           ON belp_aknr          = ak_nr
      LEFT JOIN ldsdok   ON belp_ld_id         = ld_id
      LEFT JOIN auftg    ON ld_ag_id           = ag_id
      LEFT JOIN ksv      ON belp_kostenstelle  = ks_abt
      LEFT JOIN anl      ON belp_projektnummer = an_nr      
      JOIN LATERAL ( SELECT ROUND(TBeleg.PosWert(Belegpos, FALSE, TRUE , TRUE, FALSE ),2) As PosNettoBW,
  			                ROUND(TBeleg.PosWert(Belegpos, TRUE , TRUE , TRUE, FALSE ),2) As PosBruttoBW, 
                            ROUND(TBeleg.PosWert(Belegpos, FALSE, FALSE, TRUE, FALSE ),2) As PosNettoFW,  
                            ROUND(TBeleg.PosWert(Belegpos, TRUE , FALSE, TRUE, FALSE ),2) As PosBruttoFW
      ) AS subSQL ON true         
    WHERE belp_belegtyp  = 'ERG' 
      
    UNION -- Belegbezogene Zuschläge  
    SELECT 
      belaz_konto                                                   :: VARCHAR(20)          AS pSachkonto    , -- 29	
      IfThen(posNettoBW < 0, 'T','F')                               :: VARCHAR(1)           AS pGutschrift   , -- 30	
      x_900_export.VarialFMT(ABS(posNettoBW))                                                    AS pNetto        , -- 31 Abzu.Netto, 2 NK-Stellen
      x_900_export.VarialFMT(IfThen(posNettoBW <> posNettoFW, ABS(posNettoFW),NULL))             AS pNettoFW      , -- 32 Abzu.Netto, 2 NK-Stellen, Fremdwährung
      x_900_export.VarialFMT(ABS(posBruttoBW-posNettoBW))                                        AS pSteuer       , -- 33 Steuerbetrag, 2 NK-Stellen
      x_900_export.VarialFMT(IfThen(posNettoBW <> posNettoFW, ABS(posBruttoFW-posNettoFW),NULL)) AS pSteuerFW     , -- 34 Steuerbetrag, 2 NK-Stellen, Fremwährung
      steu_buchcode                                                 :: VARCHAR(20)          AS pSteuerCode   , -- 35
  	  IfThen(belaz_canskonto, 'T','F')                              :: VARCHAR(1)           AS pCanSkonto    , -- 36	
      'T'                                                           :: VARCHAR(1)           AS pIstNetto     , -- 37	
      'E-RG '||beld_dokunr||', '||COALESCE(abz_txt, 'Ab-/Zuschlag') :: VARCHAR(80)          AS pBuchText     , -- 38 Buchungstext zum Ab-/Zuschlag	
      COALESCE(ks_buchcode, belaz_ks_abt)                           :: VARCHAR(30)          AS pKostenstelle , -- 39        
      NULL                                                          :: VARCHAR(40)          AS pKostenträger , -- 40 Keine Projektzuordnung für Belegzuschläge
      belaz_dokument_id                                                                     AS pDokumentID   , -- Zugehörige Eingangsrechnung
   	  2                                                                                     AS pOrderby        -- Sortieren nach Zeilentyp
    FROM belegabzu     
      JOIN eingrech      ON belaz_dokument_id = beld_id
      JOIN steutxt       ON belaz_steucode    = steu_z
      JOIN abzu          ON belaz_abzu_id     = abz_id
      LEFT JOIN ksv      ON belaz_ks_abt      = ks_abt      
      JOIN LATERAL ( SELECT Round(TBeleg.AbzuWert(belegabzu, FALSE, TRUE , TRUE ),2) AS PosNettoBW,
  			                Round(TBeleg.AbzuWert(belegabzu, TRUE , TRUE , TRUE ),2) AS PosBruttoBW, 
  			                Round(TBeleg.AbzuWert(belegabzu, FALSE, FALSE, TRUE ),2) AS PosNettoFW,  
  			                Round(TBeleg.AbzuWert(belegabzu, TRUE , FALSE, TRUE ),2) AS PosBruttoFW
      ) AS subSQL ON true            
    WHERE belaz_belegtyp  = 'ERG' 
    
    UNION -- Positionsbezogene Zuschläge
    SELECT 
      belpaz_konto                                                  :: VARCHAR(20)          AS pSachkonto    , -- 29	
      IfThen(posNettoBW < 0, 'T','F')                               :: VARCHAR(1)           AS pGutschrift   , -- 30	
      x_900_export.VarialFMT(ABS(posNettoBW))                                                    AS pNetto        , -- 31 Abzu.Netto, 2 NK-Stellen
      x_900_export.VarialFMT(IfThen(posNettoBW <> posNettoFW, ABS(posNettoFW),NULL))             AS pNettoFW      , -- 32 Abzu.Netto, 2 NK-Stellen, Fremdwährung
      x_900_export.VarialFMT(ABS(posBruttoBW-posNettoBW))                                        AS pSteuer       , -- 33 Steuerbetrag, 2 NK-Stellen
      x_900_export.VarialFMT(IfThen(posNettoBW <> posNettoFW, ABS(posBruttoFW-posNettoFW),NULL)) AS pSteuerFW     , -- 34 Steuerbetrag, 2 NK-Stellen, Fremwährung
      steu_buchcode                                                 :: VARCHAR(20)          AS pSteuerCode   , -- 35
  	  IfThen(belpaz_canskonto, 'T','F')                             :: VARCHAR(1)           AS pCanSkonto    , -- 36	
      'T'                                                           :: VARCHAR(1)           AS pIstNetto     , -- 37	
      'E-RG ' || beld_dokunr || ', Pos.' || belp_pos || ', ' || COALESCE(abz_txt, 'Ab-/Zuschlag')              	
                                                                    :: VARCHAR(80)          AS pBuchText     , -- 38 Buchungstext zum Ab-/Zuschlag        
      COALESCE(ks_buchcode, belp_kostenstelle)                      :: VARCHAR(30)          AS pKostenstelle , -- 39	
      COALESCE(an_buchcode, belp_projektnummer,ag_nr)               :: VARCHAR(40)          AS pKostenträger , -- 40 Projekt oder Auftrag als Kostenträger
      belp_dokument_id                                                                      AS pDokumentID   , -- Zugehörige Eingangsrechnung
      3                                                                                     AS pOrderby        -- Sortieren nach Zeilentyp 	
    FROM belegposabzu     
      JOIN eingrech_pos  ON belpaz_belegpos_id = belp_id
      JOIN eingrech      ON belp_dokument_id   = beld_id      
      JOIN steutxt       ON belpaz_steucode    = steu_z     
      JOIN abzu          ON belpaz_abzu_id     = abz_id
      LEFT JOIN ldsdok   ON belp_ld_id         = ld_id
      LEFT JOIN auftg    ON ld_ag_id           = ag_id
      LEFT JOIN ksv      ON belp_kostenstelle  = ks_abt
      LEFT JOIN anl      ON belp_projektnummer = an_nr
      JOIN LATERAL ( SELECT Round(TBeleg.AbzuWert(belegposabzu, FALSE, TRUE , TRUE ),2) As PosNettoBW,
  			                Round(TBeleg.AbzuWert(belegposabzu, TRUE , TRUE , TRUE ),2) As PosBruttoBW, 
  			                Round(TBeleg.AbzuWert(belegposabzu, FALSE, FALSE, TRUE ),2) As PosNettoFW,  
  			                Round(TBeleg.AbzuWert(belegposabzu, TRUE , FALSE, TRUE ),2) As PosBruttoFW			              
      ) AS subSQL ON true                             
    WHERE belpaz_belegtyp  = 'ERG' 
  ;   
    
  -- Eingangsrechnung. Kopfdaten in jeder Zeile wieder mitgeführt.
  CREATE OR REPLACE VIEW x_900_export.VarialERG AS
    
    SELECT    	                                                               
      'Rechnung/Gutschrift'                                           :: VARCHAR            AS DatenTyp                  ,  -- 1  
      '2'                                                             :: VARCHAR            AS Version                   ,  -- 2  
      beld_id                                                         :: BIGINT             AS ExterneID                 ,  -- 3  Eindeutige Beleg-ID für Varial  
      '10'                                                            :: VARCHAR(20)        AS Firmencode                ,  -- 4  BEIM KUNDE ANZUPASSEN 
      a2_knr                                                          :: VARCHAR(20)        AS CodePersonenkonto         ,  -- 5  Kreditorennummer 
      1                                                               :: INTEGER            AS Typ                       ,  -- 6  Debitorenbelege=0, Kreditorenbelege=1 
      NULL                                                            :: VARCHAR(20)        AS Belegart                  ,  -- 7 
      CASE WHEN beld_belegart = 1 THEN 0                              -- Umschlüsselung Belegart                                       
           WHEN beld_belegart = 2 THEN 1                                                                    
           ELSE NULL                                                                                        
      END                                                             :: INTEGER            AS Buchungstyp               ,  -- 8  Rechnung=0, Gutschrift=1   
      x_900_export.VarialFMT(beld_brutto_basis_w,TRUE)                                           AS Brutto                    ,  -- 9  Bruttobetrag, 2 NK-Stellen  
      x_900_export.VarialFMT(IfThen(beld_brutto <> beld_brutto_basis_w, beld_brutto, NULL),TRUE) AS BruttoFW                  ,  -- 10 Bruttobetrag, 2 NK-Stellen, Fremdwährung
      IfThen(beld_brutto <> beld_brutto_basis_w, beld_waehr , NULL)   :: VARCHAR(20)        AS Fremdwaehrung             ,  -- 11 
      beld_refbeleg                                                   :: VARCHAR(40)        AS BelegNrExt                ,  -- 12 Rg.Nr. Lieferanten
      beld_dokunr                                                     :: VARCHAR(40)        AS BelegNrInt                ,  -- 13 Eigene Belegnummer
      x_900_export.VarialAuftgNr(beld_id)                                  :: VARCHAR(40)   AS Auftgragsnummer           ,  -- 14 
      beld_erstelldatum                                               :: DATE               AS Belegdatum                ,  -- 15 
      COALESCE(to_date(beld_buchmonth,'MMYYYY'), beld_erstelldatum)   :: DATE               AS Buchungsdatum             ,  -- 16 - Bestimmt Buchungsmonat. Monatserste bei Buchmonth. Varial wandelt das wieder in den Buchungsmonat um.  
      'F'                                                             :: VARCHAR(1)         AS InVorjahrBuchen           ,  -- 17 
      NULL                                                            :: DATE               AS Leistungsdatum            ,  -- 18 
      COALESCE(beld_valutadatum, beld_erstelldatum)                   :: DATE               AS Valutadatum               ,  -- 19 Posteingang / Startdatum Zahlungskondition 
      beld_titel                                                      :: VARCHAR(80)        AS BuchungstextPersonenkonto ,  -- 20 
      NULL                                                            :: VARCHAR(40)        AS Zahlungskondition         ,  -- 21 
      beld_skv                                                        :: INTEGER            AS SkoTage1                  ,  -- 22 
      x_900_export.VarialFMT(beld_sks)                                                      AS SkoProzent1               ,  -- 23 
      NULL                                                            :: INTEGER            AS SkoTage2                  ,  -- 24 
      x_900_export.VarialFMT(NULL)                                                          AS SkoProzent2               ,  -- 25 
      beld_zak                                                        :: INTEGER            AS NettoTage                 ,  -- 26                 
      COALESCE(to_number(za_buchcode,'999999999'),0)                  :: INTEGER            AS Zahlungsweg               ,  -- 27
      1                                                               :: INTEGER            AS Steuertyp                 ,  -- 28 - Vorsteuer = 1, Umsatzsteuer = 2
      -- Positionsdaten                                                                 
      pos.pSachkonto    , -- 29
      pos.pGutschrift   ,
      pos.pNetto        ,
      pos.pNettoFW      ,
      pos.pSteuer       ,
      pos.pSteuerFW     ,
      pos.pSteuerCode   ,
      pos.pCanSkonto    ,
      pos.pIstNetto     ,
      pos.pBuchText     ,
      pos.pKostenstelle ,
      pos.pKostenträger , -- 40                           
      -- Hilfsdaten                                                                                    
      beld_definitiv                                                                    AS IsDefinitiv               ,  -- Feld im Export ausschließen   
      beld_exportdatum                                                                  AS Exportdatum               ,  -- Feld im Export ausschließen
      to_char(COALESCE(to_date(beld_buchmonth,'MMYYYY'),beld_erstelldatum), 'YYYY-MM')  AS BuchungsMonat             ,  -- Feld im Export ausschließen
      pos.pOrderBy                                                                                                      -- Feld im Export ausschließen
    FROM eingrechdokument
      JOIN x_900_export.VarialERGPos AS pos ON pDokumentID      = beld_id
      JOIN belegart                    ON beld_belegart    = bela_id
      LEFT JOIN zahlart                ON beld_zahlart     = za_id
      LEFT JOIN adk2                   ON beld_krzrechnung = a2_krz
    WHERE  beld_belegtyp = 'ERG'      
  ;
  
  -- Ausgangsrechnungspositionen und Ab- / Zuschläge als Zeilen abgebildet
  CREATE OR REPLACE VIEW x_900_export.VarialRGPos AS
    -- Rechnungspositionen 
    SELECT 
      bz_zeko                                                                   :: VARCHAR(20)   AS pSachkonto    , -- 29	
      IfThen(posNettoBW < 0, 'T','F')                                           :: VARCHAR(1)    AS pGutschrift   , -- 30	
      x_900_export.VarialFMT(ABS(posNettoBW))                                                         AS pNetto        , -- 31 2 NK-Stellen
      x_900_export.VarialFMT(IfThen(posNettoBW <> posNettoFW, ABS(posNettoFW),NULL))                  AS pNettoFW      , -- 32 2 NK-Stellen
      x_900_export.VarialFMT(ABS(posBruttoBW-posNettoBW))                                             AS pSteuer       , -- 33 2 NK-Stellen
      x_900_export.VarialFMT(IfThen(posNettoBW <> posNettoFW, ABS(posBruttoFW-posNettoFW),NULL))      AS pSteuerFW     , -- 34 2 NK-Stellen   
      steu_buchcode                                                             :: VARCHAR(20)   AS pSteuerCode   , -- 35
  	  'T'                                                                       :: VARCHAR(1)    AS pCanSkonto    , -- 36	
      'T'                                                                       :: VARCHAR(1)    AS pIstNetto     , -- 37
      'Pos.' || bz_pos  || ', ' || COALESCE(bz_akbz, ak_bez)                    :: VARCHAR(80)   AS pBuchText     , -- 38 Buchungstext zur Position	
      COALESCE(ks_buchcode, bz_ks)                                              :: VARCHAR(30)   AS pKostenstelle , -- 39        
      COALESCE(an_buchcode, bz_an_nr, bz_auftg)                                 :: VARCHAR(40)   AS pKostenträger , -- 40 Projekt oder Auftrag als Kostenträger
   	  bz_be_bnr                                                                                  AS pDokumentID   , -- Zugehörige Eingangsrechnung
      1                                                                                          AS pOrderBy        -- Sortieren nach Zeilentyp 	
    FROM belzeil_grund  
      JOIN belkopf  ON bz_be_bnr   = be_bnr
      JOIN steutxt  ON bz_steucode = steu_z
      LEFT JOIN art ON bz_aknr     = ak_nr
      LEFT JOIN ksv ON bz_ks       = ks_abt
      LEFT JOIN anl ON bz_an_nr    = an_nr
      JOIN LATERAL ( SELECT ROUND(bz_ep_netto * bz_fakt * COALESCE(be_umr,1)                                    ,2) AS PosNettoBW,  
  			                ROUND(bz_ep_netto * bz_fakt * (1 + COALESCE(bz_steuproz,0)/100) * COALESCE(be_umr,1),2) AS PosBruttoBW, 
                            ROUND(bz_ep_netto * bz_fakt                                                         ,2) AS PosNettoFW,  
                            ROUND(bz_ep_netto * bz_fakt * (1 + COALESCE(bz_steuproz,0)/100)                     ,2) AS PosBruttoFW
      ) AS subSQL ON true         
    WHERE be_prof IN ('R','G') AND bz_ep_netto IS NOT NULL -- Reine Textzeilen ausschließen   
    UNION -- Zuschläge zur Rechnung oder Position  
    SELECT 
      beaz_konto                                                                        :: VARCHAR(20)   AS pSachkonto  , -- 29	
      IfThen(beaz_tot < 0, 'T','F')                                                     :: VARCHAR(1)    AS pGutschrift , -- 30	
      x_900_export.VarialFMT(ABS(beaz_tot_basis_w),TRUE)                                                      AS pNetto      , -- 31 2 NK-Stellen
      x_900_export.VarialFMT(IfThen(beaz_tot_basis_w <> beaz_tot, ABS(beaz_tot), NULL),TRUE)                  AS pNettoFW    , -- 32 2 NK-Stellen     
      x_900_export.VarialFMT(ABS(ROUND(beaz_tot_steu_basis_w,2)-ROUND(beaz_tot_basis_w,2)),TRUE)              AS pSteuer     , -- 33 2 NK-Stellen, dann Differenz bilden
      x_900_export.VarialFMT(IfThen(beaz_tot_basis_w <> beaz_tot, 
                                           ABS(ROUND(beaz_tot_steu,2)-ROUND(beaz_tot,2)), NULL),TRUE)    AS pSteuerFW   , -- 34 2 NK-Stellen, dann Differenz bilden
      steu_buchcode                                                                     :: VARCHAR(20)   AS pSteuerCode , -- 35
  	  IfThen(beaz_canSkonto, 'T','F')                                                   :: VARCHAR(1)    AS pCanSkonto  , -- 36	
      'T'                                                                               :: VARCHAR(1)    AS pIstNetto   , -- 37
      'A-RG ' || be_bnr || ifThen(beaz_belpos IS NOT NULL, ', Pos.' || beaz_belpos,'') || ', ' || COALESCE(abz_txt, 'Ab-/Zuschlag')	
                                                                      :: VARCHAR(80)   AS pBuchText     , -- 38	
      COALESCE(ks_buchcode, bz_ks)                                    :: VARCHAR(30)   AS pKostenstelle , -- 39        
      COALESCE(an_buchcode, bz_an_nr, beaz_agnr)                      :: VARCHAR(40)   AS pKostenträger , -- 40
      beaz_bebnr                                                                       AS pDokumentID   , -- Zugehörige Eingangsrechnung
   	IfThen(beaz_belpos IS NULL, 2, 3)                                                  AS pOrderBy        -- Sortieren nach Zeilentyp
    FROM belabzu     
      JOIN belkopf            ON beaz_bebnr  = be_bnr
      JOIN steutxt            ON beaz_steu   = steu_z
      JOIN abzu               ON beaz_abz_id = abz_id      
      LEFT JOIN belzeil_grund ON beaz_bebnr  = bz_be_bnr AND beaz_belpos = bz_pos  
      LEFT JOIN ksv           ON bz_ks       = ks_abt
      LEFT JOIN anl           ON an_buchcode = bz_an_nr
    WHERE be_prof IN ('R','G')   
  ;  
                                                          
  -- Ausgangsrechnungen. Kopfdaten in jeder Zeile wieder mitgeführt.
  CREATE OR REPLACE VIEW x_900_export.VarialRG AS
    
    SELECT    	                                      
      'Rechnung/Gutschrift'                                           :: VARCHAR       AS DatenTyp                  ,  -- 1  
      '2'                                                             :: VARCHAR       AS Version                   ,  -- 2  
      belkopf.dbrid                                                   :: BIGINT        AS ExterneID                 ,  -- 3  
      '10'                                                            :: VARCHAR(20)   AS Firmencode                ,  -- 4 - BEIM KUNDE ANZUPASSEN?!  
      a1_knr                                                          :: VARCHAR(20)   AS CodePersonenkonto         ,  -- 5  
      0                                                               :: INTEGER       AS Typ                       ,  -- 6  
      NULL                                                            :: VARCHAR(20)   AS Belegart                  ,  -- 7  
      CASE WHEN be_prof = 'R' THEN 0                                  -- Umschlüsselung Belegart                                                      
           WHEN be_prof = 'G' THEN 1                                                   
           ELSE NULL                                                                   
      END                                                             :: INTEGER       AS Buchungstyp               ,  -- 8                                                                                
      x_900_export.VarialFMT(be_gesamt_steu_basis_w,TRUE)                                   AS Brutto                    ,  -- 9  2 NK-Stellen  
      x_900_export.VarialFMT(IfThen(be_gesamt_steu <> be_gesamt_steu_basis_w, be_gesamt_steu, NULL),TRUE) 
                                                                                       AS BruttoFW                  ,  -- 10 2 NK-Stellen 
      IfThen(be_gesamt_steu <> be_gesamt_steu_basis_w, be_waco, NULL) :: VARCHAR(20)   AS Fremdwährung              ,  -- 11
      be_bnr                                                          :: VARCHAR(40)   AS BelegNrExt                ,  -- 12 
      NULL                                                            :: VARCHAR(40)   AS BelegNrInt                ,  -- 13 
      NULL                                                            :: VARCHAR(40)   AS Auftgragsnummer           ,  -- 14 
      be_bdat                                                         :: DATE          AS Belegdatum                ,  -- 15 
      COALESCE(to_date(be_buchmonth,'MMYYYY'),be_bdat)                :: DATE          AS Buchungsdatum             ,  -- 16 - Bestimmt Buchungsmonat. Monatserste bei Buchmonth. Varial wandelt das wieder in den Buchungsmonat um. 
      'F'                                                             :: VARCHAR(1)    AS InVorjahrBuchen           ,  -- 17 
      NULL                                                            :: DATE          AS Leistungsdatum            ,  -- 18 
      be_valuta                                                       :: DATE          AS Valutadatum               ,  -- 19 
      be_allg1                                                        :: VARCHAR(80)   AS BuchungstextPersonenkonto ,  -- 20 
      NULL                                                            :: VARCHAR(40)   AS Zahlungskondition         ,  -- 21 
      be_skv                                                          :: INTEGER       AS SkoTage1                  ,  -- 22 
      x_900_export.VarialFMT(be_sks)                                                   AS SkoProzent1               ,  -- 23 
      NULL                                                            :: INTEGER       AS SkoTage2                  ,  -- 24 
      x_900_export.VarialFMT(NULL)                                                     AS SkoProzent2               ,  -- 25 
      be_zak                                                          :: INTEGER       AS NettoTage                 ,  -- 26 
      COALESCE(to_number(za_buchcode,'999999999'),0)                  :: INTEGER       AS Zahlungsweg               ,  -- 27 
      2                                                               :: INTEGER       AS Steuertyp                 ,  -- 28 
      -- Positionsdaten                                                                 
      pos.pSachkonto    , -- 29
      pos.pGutschrift   ,
      pos.pNetto        ,
      pos.pNettoFW      ,
      pos.pSteuer       ,
      pos.pSteuerFW     ,
      pos.pSteuerCode   ,
      pos.pCanSkonto    ,
      pos.pIstNetto     ,
      pos.pBuchText     ,
      pos.pKostenstelle ,
      pos.pKostenträger , -- 40    
      -- Hilfsdaten 
      be_def                                                                           AS IsDefinitiv               ,  -- Feld im Export ausschließen
      be_buchdat                                                                       AS Exportdatum               ,  -- Feld im Export ausschließen
      to_char(COALESCE(to_date(be_buchmonth,'MMYYYY'),be_bdat), 'YYYY-MM')             AS BuchungsMonat             ,  -- Feld im Export ausschließen
      pos.pOrderBy                                               -- Feld im Export ausschließen    
    FROM belkopf
      JOIN x_900_export.VarialRGPos AS pos ON pDokumentID = be_bnr
      LEFT JOIN zahlart               ON be_zahlart  = za_id
      LEFT JOIN belart                ON be_txba     = ba_id  
      LEFT JOIN adressen_view         ON ad_krz      = be_rkrz     -- Wegen Debitorendaten
      LEFT JOIN adk1                  ON a1_krz      = adk_ad_krz  -- Debitorendaten zur Adresse                  
    WHERE be_prof IN ('R','G')      
  ;
  */  
 END $$ LANGUAGE plpgsql;
--

-- SELECT TSystem.views__x_900_export__varial__recreate(); --TODO wieder einbauen wenn nötig


-- SELECT * FROM x_900_export.VarialRG;
